; hello world!
; a cool demo by eKid

;------------------------------------------
; vectors
;------------------------------------------

; um, reset vectors?

	section "VECTOR00",HOME[$00]
RST_00:
	jp	$100	; $100 is program start in cartridge header.

	section	"VECTOR08",HOME[$08]
RST_08:
	jp	$100

	section	"VECTOR10",HOME[$10]
RST_10:
	jp	$100

	section	"VECTOR18",HOME[$18]
RST_18:
	jp	$100

	section	"VECTOR20",HOME[$20]
RST_20:
	jp	$100

	section	"VECTOR28",HOME[$28]
RST_28:
	jp	$100

	section	"VECTOR30",HOME[$30]
RST_30:
	jp	$100

	section	"VECTOR38",HOME[$38]
RST_38:
	jp	$100

; irq vectors
	
	section "VBLANK_VECTOR",HOME[$40]
VBL_VECT:
	reti	; do nothing

	section "LCD_VECTOR",HOME[$48]
LCD_VECT:
	reti	; do nothing

	section "TIMER_VECTOR",HOME[$50]
TIMER_VECT:
	reti	; do nothing

	section "SERIAL_VECTOR",HOME[$58]
SERIAL_VECT:
	reti	; do nothing

	section "JOYPAD_VECTOR",HOME[$60]
JOYPAD_VECT:
	reti	; do nothing!

;---------------------------------------------------------
; cartridge header
;---------------------------------------------------------

	section "CHEADER",HOME[$100]
CARTRIDGE_HEADER:
	
	; 0100-0103 Program Entry point
	jp	START
	nop
	
	; 0104-0133 Nintendo logo, must be exact or gb will refuse to run program
	db	$CE,$ED,$66,$66,$CC,$0D,$00,$0B,$03,$73,$00,$83,$00,$0C,$00,$0D
	db	$00,$08,$11,$1F,$88,$89,$00,$0E,$DC,$CC,$6E,$E6,$DD,$DD,$D9,$99
	db	$BB,$BB,$67,$63,$6E,$0E,$EC,$CC,$DD,$DC,$99,$9F,$BB,$B9,$33,$3E
	
	; 0134-013E Game title 11 chars
	db	"HELLO WORLD"
	
	; 013f-0142 Manufacturer code
	db	"    "
	
	; 0143 CGB flag
	db	$C0	; cgb only
	
	; 0144-0145 License code
	db	$00, $00
	
	; 0146 SGB flag
	db	$00
	
	; 0147 Cartridge Type
	db	$19
	
	; 0148 ROM size
	db	$00	; 32kb ROM
	
	; 0149 RAM size
	db	$00	; no cartridge ram
	
	; 014A destination code
	db	$01	; non-japan
	
	; 014B old licensee code
	db	$33	; $33 fixed, required
	
	; 014C mask ROM version - handled by RGBFIX
	db	$00
	
	; 014d header checksum - handled by RGBFIX
	db	$00	; required!
	
	; 014e-014f global checksum - handled by RGBFIX
	dw	$0000	; not required

;------------------------------------------
; graphics
;------------------------------------------

	section "GRAPHICS",DATA

scribbles:
	include "scribbles.inc"

;------------------------------------------
; vram memory definition
;------------------------------------------

	section "VRAM_A",VRAM

; 4-bit font data
; 16 bytes per tile

vr_font:
	ds	27*16	; reserve space

;------------------------------------------
; definitions
;------------------------------------------

DONUT_ISGOOD	EQU	$01

NR52		EQU	$FF26

LCDC		EQU	$FF40
STAT		EQU	$FF41
SCY		EQU	$FF42
SCX		EQU	$FF43
LY		EQU	$FF44
BCPS		EQU	$FF68
BCPD		EQU	$FF69
IE		EQU	$FFFF

;------------------------------------------
; program
;------------------------------------------

	section "HELLOWORLD",HOME[$150]
	
START::
	di	; disable interrupts
	
	xor	a		; disable sound (16% power saving)
	ld	[NR52], a
	
; wait for vblank

.dwait:
	ld	a, [LY]
	cp	a, 146		; +2 :)
	jr	nz, .dwait

; disable LCD
	
	xor	a
	ld	[LCDC], a
	
; load scribble font :D
	
	ld	bc, vr_font
	ld	hl, scribbles
	ld	de, 27*256 + 16
	
.copyfont:
	ld	a, [hl+]
	ld	[bc], a
	inc	bc
	dec	e
	jr	nz, .copyfont
	ld	e, 16
	dec	d
	jr	nz, .copyfont
	
	
; build a cool palette :]
	
	ld	a, $80		; index 0, auto-inc
	ld	[BCPS], a
	
	ld	hl, BCPD
	ld	[hl], $ff	; white
	ld	[hl], $7f
	ld	[hl], $1f	; red
	ld	[hl], $00
	ld	[hl], $1f	; red
	ld	[hl], $00
	ld	[hl], $1f	; red
	ld	[hl], $00
	
; draw the text
; start by clearing the screen
	
	ld	hl, $9800
	xor	a
	ld	de, 1024

.clearscreen:
	ld	[hl], $00
	inc	hl
	dec	de
	jp	nz, .clearscreen
	
; write text
	
	ld	hl, str_message
	ld	bc, $9800-1
	
.writetext:
	ld	a, [hl+]
	cp	0
	jr	z, .endtext
	inc	bc
	sub	64
	jr	c, .writetext
	ld	[bc], a
	jr	.writetext
.endtext:

; center image

	ld	a, -68
	ld	[SCY], a
	ld	a, -36
	ld	[SCX], a
	
	ld	a, $91		; enable lcd
	ld	[LCDC], a
	
	halt			; crash program (low power consumption)
	; rgbasm adds a NOP

str_message:
db	"HELLO@WORLD",0 ; the @ is a space :(
